<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Userdata extends CI_Controller {
	

	/**
     * CodeIgniter
     * @package         Survey
     * @author          Reshma Rajan
     * @since           Version 1.0
     * Date:            9-05-2017 
     
     */ 
	 function __construct() {
		  parent::__construct();
       
         $this->load->model('userdata__model');
         $this->load->model('User_model');
         $this->load->library('form_validation');
     	 $this->role = $this->session->userdata('role');
		 $this->userid = $this->session->userdata('id');
		 $this->status = $this->session->userdata('status');
		 $this->taluk = $this->session->userdata('taluk');
		$this->panchayath = $this->session->userdata('panchayath');
		$this->district = $this->session->userdata('district');
	     
    }
    /**
     * CodeIgniter
     * @package         Survey
     * @author          Reshma Rajan
     * @since           Version 1.0
     * Date:            9-05-2017 
     Description : user list
     */ 
	 public function userdata_list()
	    { 
		  		
	      $data['agents']=$this->userdata__model->get_agent_list();
		  $data['district_all']	=	$this->User_model->getLocation('district','','');
		  $data['district']  	= 	$this->district;
		  $data['role']  		= 	$this->role;
		  
		  if($this->role == AGENT)
		  {
			   $data['user_type'] = $this->uri->segment(3);
			  $this->load->view('header');
			  $this->load->view('individual_userdata_list',$data);
		  }
		  else
		  {
			  $data['user_type'] = $this->uri->segment(3);
			  $this->load->view('header');
			  $this->load->view('userdata_list',$data);
		  }
			 
	 	}
		
	/**
     * CodeIgniter
     * @package         Survey
     * @author          Reshma Rajan
     * @since           Version 1.0
     * Date:            9-05-2017 
     Description : user list
     */ 
	function get_usersdata_list()
		{
			
			$data=array();            
			$data['id'] = $this->userid;
			$data['role'] = $this->role; 
			$data['user_id'] = $this->userid;
			$this->district = $this->session->userdata('district');
			
			/* if($this->role == AGENT) 
			{	
		
		        $joins = array(
					array(
					'table' => 'taluk_all',
					'condition' => 'user_data.taluk_name=taluk_all.id',
					'jointype' => 'LEFT'
					),	 
					array(
					'table' => 'panchayath',
					'condition' => 'user_data.grama_panchayath=panchayath.id',
					'jointype' => 'LEFT'
					),
				  );
				 // Give condtion and value for filtering
				$select_condtion = array(              
					  array(
						'key' => 'user_data.userId',
						'value' => $data['id']
						),
						 array(
						'key' => 'user_data.status',
						'value' => ACTIVE
						)
				);
				
				$select_fields ='user_data.name,panchayath.panchayath_name,taluk_all.taluk_name,DATE_FORMAT(user_data.created_at, "%d-%m-%Y"),user_data.id';
		        $table_id='user_data';
				$search_like = array('user_data.name','taluk_all.taluk_name','panchayath.panchayath_name');
			} */
			//->join('categories AS alvl', 'content.alvl = alvl.id');
			$select_condtion = array( array('key' => 'survey_family.status','value' => ACTIVE));
			$joins 			= 	array(
											array(
											'table' => 'login',
											'condition' => 'login.id=survey_family.agent_id',
											'jointype' => 'JOIN'
											),
											array(
											'table' => 'location_settings_master',
											'condition' => 'location_settings_master.id=login.district_id',
											'jointype' => 'JOIN'
											),
											array(
											'table' => 'location_settings_master as b',
											'condition' => 'b.id=login.block_id',
											'jointype' => 'JOIN'
											)
							  				);	
			if($this->role == DISTRICT_AGENT)
				{	
					$log_user_district  =   $this->district;
					$get_all_agent_ids	=	$this->userdata__model->get_all_agent($log_user_district);	
						$ids=array();
					foreach($get_all_agent_ids as $eachAgt)
						{
							$ids[]=$eachAgt['id'];
						}
					
			   }
			if($this->role == ADMIN)
				{
					$ids[]				=	'';
				}
			if(isset($_POST['agent']) && $_POST['agent'] !='')
			{
				$select_condtion[] = array('key' => 'survey_family.agent_id','value' => $_POST['agent']);	
			}
			if(isset($_POST['survey_status']) && $_POST['survey_status'] !='')
			{
				$select_condtion[] = array('key' => 'survey_family.survey_status','value' => $_POST['survey_status']);	
			}
			if(isset($_POST['agent_data']) && $_POST['agent_data'] !='')
			{
				$select_condtion[] = array('key' => 'login.id','value' => $_POST['agent_data']);	
			}
			$table_id 		=	'survey_family';	
			$select_fields 	=	"login.id,login.name as agent_name,survey_family.family_id as familyId,survey_family.name,survey_family.address,survey_family.village,survey_family.ward_no,survey_family.ration_card_no,to_char(survey_family.suvey_date, 'DD-MON-YYYY'),location_settings_master.name as district,b.name as block";
			$search_like 	= 	array('survey_family.name','survey_family.address','survey_family.village','survey_family.ward_no','survey_family.ration_card_no');   
			$category_array = 	array();
			$search_value 	= 	trim($_POST['search_text']);
			$user_type 		=  	$this->input->post('user_type');
			$limit 			= 	array('start' => $_POST['start'] , 'length' => $_POST['length']);
			$order_by 		= 	array('key' => 'survey_family.family_id', 'type' => 'desc');
			if($this->role == ADMIN)
				{
					$data 			= 	$this->userdata__model->common_get_pipeline($table_id,$select_fields,$select_condtion,$search_value,$search_like,$joins,$limit,$order_by,'survey_family.agent_id');
				}
			else	
				{
					$data 			= 	$this->userdata__model->common_get_pipeline($table_id,$select_fields,$select_condtion,$search_value,$search_like,$joins,$limit,$order_by,'survey_family.agent_id',$ids);
				}		
			//$data 			= 	$this->userdata__model->common_get_pipeline($table_id,$select_fields,$select_condtion,$search_value,$search_like,$joins,$limit,$order_by,'survey_family.agent_id',$ids);
			
			echo $data;							
		}
		/**
     * CodeIgniter
     * @package         Survey
     * @author          Reshma Rajan
     * @since           Version 1.0
     * Date:            9-05-2017 
     Description : view_survey
     */ 
	 public function view_survey()
	 {
		 
	 	if($this->userid =''){
	 		redirect('user');
	 	}
	 	$data['id'] 	=	$this->uri->segment(2);
	 	if(isset($data['id']) && $data['id']!='' && is_numeric($data['id']))
		 	{
		 		$family_details 			=	$this->userdata__model->get_family($data['id']);
		 		$view['member_details'] 	=	$this->userdata__model->get_family_members($data['id']);
		 		$services 					=	$this->userdata__model->get_services($data['id']);
		 		$issues 					=	$this->userdata__model->get_issues($data['id']);
				$diseases_arry 				= 	array();
				//echo '<pre>';print_r($services);die;
		 		foreach ($view['member_details'] as $key => $value) 
			 		{
			 			if($value['physical_condition'] == 1)//2-no issue 1-have issue
				 			{
				 				$diseases 	= 	$this->userdata__model->get_diseases($value['member_id']);
				 				$value['diseases']=	$diseases;
				 				$diseases_arry[$key]=$value;
				 			}
				 		else
				 			{
				 				$diseases_arry[$key]=$value;
				 			}
				 		if(!empty($value['job']))
				 			{
				 				$job_details 		= 	$this->userdata__model->get_job($value['job']);
				 				if($value['job'] == 11)
				 					{
				 						$others 	=	$value['memberJobDetails'];
				 						$diseases_arry[$key]['job_title']=	$job_details->title .' ( '.$others . ' )';
				 					}
				 				else
				 					{
				 						$diseases_arry[$key]['job_title']=	$job_details->title;
				 					}	
				 			}
				 		$relation_details 				= 	$this->userdata__model->get_relation($value['family_relation']);
				 		if(!empty($relation_details->title))
				 			{
				 				$diseases_arry[$key]['relation']=	$relation_details->title;
				 			}
				 		else
				 			{
				 				$diseases_arry[$key]['relation']=	'-';
				 			}	
			 		}
			 	$diseases_arry1['family_details']	=	$family_details;
			 	$diseases_arry1['member_details']	=	$diseases_arry;
			 	$diseases_arry1['services']			=	$services;
			 	$diseases_arry1['issues']			=	$issues;
			 	$diseases_arry1['FAMILY_ID']		=	$data['id'];
				$ration_card_color 					=	$family_details->ration_card_color;
				$ration_color						=	$this->User_model->ration_card_color($ration_card_color);
				$agent_who							=	$family_details->agent_id;
				$details							=	$this->userdata__model->get_agent_details($agent_who);
				if(isset($ration_color[0]['title']) && !empty($ration_color[0]['title']))
					{
						$diseases_arry1['ration_color']	=	$ration_color[0]['title'];
					}
				else
					{
						$diseases_arry1['ration_color']	=	'';
					}
				if(isset($details[0]['district_id']) && !empty($details[0]['district_id']))
					{
						$loc	= $this->User_model->getLocationById($details[0]['district_id'],'district');
						$diseases_arry1['district']	=	$loc[0]['name'];
					}
				if(isset($details[0]['block_id']) && !empty($details[0]['block_id']))
					{
						$loc	= $this->User_model->getLocationById($details[0]['block_id'],'block');
						$diseases_arry1['block']	=	$loc[0]['name'];
					}
				if(isset($details[0]['taluk_id']) && !empty($details[0]['taluk_id']))
					{
						$loc	= $this->User_model->getLocationById($details[0]['taluk_id'],'taluk');
						$diseases_arry1['taluk']	=	$loc[0]['name'];
					}
				if(isset($details[0]['corporation']) && !empty($details[0]['corporation']))
					{
						$loc	= $this->User_model->getLocationById($details[0]['corporation'],'corporation');
						$diseases_arry1['corporation']	=	$loc[0]['name'];
					}
				if(isset($details[0]['muncipality']) && !empty($details[0]['muncipality']))
					{
						$loc	= $this->User_model->getLocationById($details[0]['muncipality'],'muncipality');
						$diseases_arry1['muncipality']	=	$loc[0]['name'];
					}
				if(isset($details[0]['panchayath_id']) && !empty($details[0]['panchayath_id']))
					{
						$loc	= $this->User_model->getLocationById($details[0]['panchayath_id'],'panchayath');
						$diseases_arry1['panchayath']	=	$loc[0]['name'];
					}
				if(isset($details[0]['cds']) && !empty($details[0]['cds']))
					{
						$diseases_arry1['CDS']	=	$details[0]['cds'];
					}
				if(isset($details[0]['ads']) && !empty($details[0]['ads']))
					{
						$diseases_arry1['ADS']	=	$details[0]['ads'];
					}
				if(isset($details[0]['constitution']) && !empty($details[0]['constitution']))
					{
						$diseases_arry1['constitution']	=	$details[0]['constitution'];
					}	
			 	
				
		 		if(isset($diseases_arry1) && !empty($diseases_arry1))
			 		{
				 		$this->load->view('header');
						$this->load->view('view_survey',$diseases_arry1);
					}
				else
					{
						redirect('user');
					}
		 	}
	 	else
		 	{
		 		redirect('user');
		 	}
	 }
	 public function survey_update()
	 	{
	 		$FAMILY_ID    	= 	$_REQUEST['FAMILY_ID'];
	 		$type    		= 	$_REQUEST['type'];
	 		if($type==1)		$update_arr=array('name'=> $_REQUEST['name'] );
	 		if($type==2)		$update_arr=array('address'=>$_REQUEST['address'] );
	 		//print_r($update_arr);die;
            $result = $this->User_model->update_survey($update_arr,$FAMILY_ID);
	 	}
	 /*
	 Image upload DEMO
	 */
	 public function upload_file($id,$i)
        {
    	   	$target_dir = "uploads/";
    	   	print_r($_FILES);die;
			$target_file = $target_dir . basename($_FILES["image"]["name"]);
			$uploadOk = 1;
			$imageFileType = pathinfo($target_file,PATHINFO_EXTENSION);
			// Check if image file is a actual image or fake image
			if(isset($_POST["submit"])) {
			    $check = getimagesize($_FILES["image"]["tmp_name"]);
			    if($check !== false) {
			        echo "File is an image - " . $check["mime"] . ".";
			        $uploadOk = 1;
			    } else {
			        echo "File is not an image.";
			        $uploadOk = 0;
			    }
			}
			// Check if file already exists
			if (file_exists($target_file)) {
			    echo "Sorry, file already exists.";
			    $uploadOk = 0;
			}
			// Check file size
			if ($_FILES["image"]["size"] > 500000) {
			    echo "Sorry, your file is too large.";
			    $uploadOk = 0;
			}
			// Allow certain file formats
			if($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
			&& $imageFileType != "gif" ) {
			    echo "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
			    $uploadOk = 0;
			}
			// Check if $uploadOk is set to 0 by an error
			if ($uploadOk == 0) {
			    echo "Sorry, your file was not uploaded.";
			// if everything is ok, try to upload file
			} else {
			    if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
			        echo "The file ". basename( $_FILES["image"]["name"]). " has been uploaded.";
			    } else {
			        echo "Sorry, there was an error uploading your file.";
			    }
			}

        }
    /*
    
    */
    public function export_agent()
    	{
    		  
			  $data['seach_val'] 	= trim($this->uri->segment(5));
		 	  $data['id'] 			= trim($this->uri->segment(4));
		 	  $data['agent_id'] 	= trim($this->uri->segment(3));
		 	  $data['search_like'] 	= array('login.name');
			  $dt['details'] 		= $this->userdata__model->get_agent_export($data);
			  
    	}    
		/**
     * CodeIgniter
     * @package         Survey
     * @author          Reshma Rajan
     * @since           Version 1.0
     * Date:            9-05-2017 
     Description : export_data
     */ 	
	public function export_data()
	 {
		 
  		$data['survey_status'] = trim($this->uri->segment(5));
 	  	$data['seach_val'] = trim($this->uri->segment(4));
 	  	//$data['id'] = trim($this->uri->segment(4));
 	  	$data['agent_id'] = trim($this->uri->segment(3));
 	  	$data['search_like'] = array('login.name','login.address','login.village');
 	  	$dt['details'] = $this->userdata__model->get_report_export($data);
	  
	  if($dt['details'] ){
        
        $filename = "Survey_Reports";
  
        $dt['filename']=   $filename;     
       
        
        $this->load->view('report_export',$dt);
    }else
    {
        redirect('userdata/userdata_list');
    }
    
   }
   	/**
     * CodeIgniter
     * @package         Survey
     * @author          Reshma Rajan
     * @since           Version 1.0
     * Date:            9-05-2017 
     Description : export_data
     */ 
   function print_application()
	{
		ob_start();
		$data['id'] 				= 	trim($this->uri->segment(2));
		$family_details 			=	$this->userdata__model->get_family($data['id']);
		$view['member_details'] 	=	$this->userdata__model->get_family_members($data['id']);
		$services 					=	$this->userdata__model->get_services($data['id']);
		$issues 					=	$this->userdata__model->get_issues($data['id']);
		$diseases_arry 				= 	array();		 		
		foreach ($view['member_details'] as $key => $value) 
			{
				if($value['physical_condition'] == 1)//2-no issue 1-have issue
					{
						$diseases 	= 	$this->userdata__model->get_diseases($value['member_id']);
						$value['diseases']=	$diseases;
						$diseases_arry[$key]=$value;
					}
				else
					{
						$diseases_arry[$key]=$value;
					}
				if(!empty($value['job']))
					{
						$job_details 		= 	$this->userdata__model->get_job($value['job']);
						if($value['job'] == 11)
							{
								$others 	=	$value['memberJobDetails'];
								$diseases_arry[$key]['job_title']=	$job_details->title .' ( '.$others . ' )';
							}
						else
							{
								$diseases_arry[$key]['job_title']=	$job_details->title;
							}	
					}
				$relation_details 				= 	$this->userdata__model->get_relation($value['family_relation']);
				if(!empty($relation_details->title))
					{
						$diseases_arry[$key]['relation']=	$relation_details->title;
					}
				else
					{
						$diseases_arry[$key]['relation']=	'-';
					}	
			}
		$user_details['family_details']	=	$family_details;
		$user_details['member_details']	=	$diseases_arry;
		$user_details['services']		=	$services;
		$user_details['issues']			=	$issues;

		$member_array 					= 	$user_details['member_details'];
		$member_services 				= 	$user_details['services'];
		$member_issues 					= 	$user_details['issues'];
		//echo '<pre>';print_r($user_details);
		$place_category = $family_details->place_category;
	    if($place_category == 1) {$p_cate = 'Rural';}
	    else {$p_cate = 'Urban';}
	    $category = $family_details->category;
	    if($category == 1) {$cate = 'SC';}
	    if($category == 2) {$cate = 'ST';}
	    if($category == 3) {$cate = 'General ( ' . $family_details->general_specify . ' )';}
	    if($category == 0) {$cate = '-NA-';}

	    $ration_card = $family_details->ration_card;
	    if($ration_card == 1) {$card = 'yes';}
	    else {$card = 'No';}

	    $ayal_type = $family_details->ayalkootam_member;
	    if($ayal_type == 1) {$ayal_mem = 'yes';}
	    else {$ayal_mem = 'No';}

	    $old_stay = $family_details->oldage_home_stay;
	    if($old_stay == 1) {$old_mem = 'yes';}
	    else {$old_mem = 'No';}

	    $profile_pic = $family_details->profile_pic;
    	if(isset($profile_pic) && $profile_pic !='' && file_exists("uploads/".$profile_pic))
	    	{
	    		$image = '<img style="float: right;width:80px" class="imgPic" src="'.base_url('uploads/').''.$family_details->profile_pic.'"/>';
	    	}
	   	else
	   		{
	   			$image = '<img style="float: right;width:80px" class="imgPic" src="'.base_url('images/dummy_img.jpeg').'"/>';
	   		}
    	if(isset($user_details) && !empty($user_details))
			{
				$this->load->library('tcpdf/tcpdf');
				$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
				$pdf->SetCreator(PDF_CREATOR);
				$pdf->SetTitle('Kudunbashree - Survey');
				$page 					= 'Survey ID :- '.$data['id'];
				$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, $page, '');
				$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
				$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
				$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
				//$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
				$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
				$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
				$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
				$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

				//$pathUrl 	=  	base_url('fonts/mala/MLKR0ntt.ttf');
				//$fontname 	= 	$pdf->addTTFfont($pathUrl, 'TrueTypeUnicode', '', 32);
				//$pdf->SetFont($fontname, '', 14, '', false);

				$lg 					= Array();
				$lg['a_meta_charset'] 	= 'UTF-8';
				$lg['a_meta_dir'] 		= 'rtl';
				$lg['a_meta_language'] 	= 'fa';
				$lg['w_page'] 			= 'kudumbasree-survey page';
				$pdf->setLanguageArray($lg);
				$pdf->AddPage();
				$pdf->SetFontSize(8);
				$pdf->setRTL(false);
				$pdf->Ln();
				//anjalioldlipi , freesans
				$pdf->SetFont('freesans', '', 12);
				$htmlcontent2 = '<div style="text-align:center"><p style="color:#852771">ആശ്രയ പദ്ധതി</p><br><p><u>കുടുംബ അവലോകന ഫോറം </u></p></div>';
				$html_content2 ='<div >'.$image.'</div>';
				$htmlcontent2 .='<p>ഗ്രാമ പഞ്ചായത്ത് / നഗരസഭാ  :<u>'.$p_cate.'</u></p>
				    <p>വിലയിരുത്തൽ തിയതി :<u>'.$family_details->suvey_date.'</u></p>
				    <p>1.കുടുംബനാഥ(ൻ) യുടെ പേര്  : <u>'.$family_details->name.'</u></p>
				    <p>2.മേൽവിലാസം :<u>'.$family_details->address.'</u></p>    
				    <p>3.വിഭാഗം  :<u>'.$cate.'</u></p>
				    <p>4.വില്ലജ്   :<u>'.$family_details
				    ->village.'</u></p>
				    <p>5.വാർഡ് നമ്പർ , വീട് നമ്പർ    :<u>'.$family_details->ward_no.'</u> , <u>'.$family_details->house_no.'</u></p>
				    <p>6.കുടുംബത്തിലെ ആകെ ആംഗങ്ങൾ     :<u>'.$family_details->family_members.'</u></p>
				    <p>7.റേഷൻ കാർഡ് ഉണ്ടോ ?  :<u>'.$card.'</u></p>';
				    if($card == "yes"){
				    $htmlcontent2 .='<p>എ).റേഷൻ കാർഡ് നമ്പർ  :<u>'.$family_details->ration_card_no.'</u></p>
				    <p>ബി).റേഷൻ ഷോപ് നമ്പർ   :<u>'.$family_details->ration_shop_no.'</u></p>
				    <p>സി).റേഷൻ കാർഡ് കളർ    :<u>'.$family_details->ration_card_color.'</u></p>';
				     }
				    $htmlcontent2 .='<p>8.ഭൂമി</p>
				    <p>എ).സ്വന്തമായി ഭൂമി ഉണ്ടോ    ?  :<u>'.$family_details->land.'</u></p>
				    <p>ബി).ഉണ്ടെങ്കിൽ  എത്ര  സെന്റ്  ?  :<u>'.$family_details->land_cent.'</u></p>
				    <p>9.കുടുംബശ്രീ അയൽക്കൂട്ടത്തിൽ അംഗംമാനോ  ? <u>'.$ayal_mem.'</u></p>
				    <?php if($ayal_mem == "yes"){?>
				    <p>എ).അയൽക്കൂട്ടത്തിന്റെ  പേരു  ?  :<u>'.$family_details->ayalkootam_name.'</u></p>
				    <p>ബി).ഉൾപ്പെടുന്ന വാർഡ് നമ്പർ      ?  :<u>'.$family_details->ayalkootam_ward_no.'</u></p>
				    <?php }?>
				    <p>10.അഗതിമന്ദിരത്തിൽ താമസിക്കാൻ തയാറാണോ ?: <u>'.$old_mem.'</u></p>';
				    
				    $html_content2 ='<table cellspacing="0" cellpadding="1" border="1">
				    <p>ഗ്രാമ പഞ്ചായത്ത് / നഗരസഭാ  :<u>'.$p_cate.'</u></p>
				    <p>വിലയിരുത്തൽ തിയതി :<u>'.$family_details->suvey_date.'</u></p>
				    <p>1.കുടുംബനാഥ(ൻ) യുടെ പേര്  : <u>'.$family_details->name.'</u></p>
				    <p>2.മേൽവിലാസം :<u>'.$family_details->address.'</u></p>    
				    <p>3.വിഭാഗം  :<u>'.$cate.'</u></p>
				    <p>4.വില്ലജ്   :<u>'.$family_details
				    ->village.'</u></p>
				    <p>5.വാർഡ് നമ്പർ , വീട് നമ്പർ    :<u>'.$family_details->ward_no.'</u> , <u>'.$family_details->house_no.'</u></p>
				    <p>6.കുടുംബത്തിലെ ആകെ ആംഗങ്ങൾ     :<u>'.$family_details->family_members.'</u></p>
				    <p>7.റേഷൻ കാർഡ് ഉണ്ടോ ?  :<u>'.$card.'</u></p>
				    <?php if($card == "yes"){?>
				    <p>എ).റേഷൻ കാർഡ് നമ്പർ  :<u>'.$family_details->ration_card_no.'</u></p>
				    <p>ബി).റേഷൻ ഷോപ് നമ്പർ   :<u>'.$family_details->ration_shop_no.'</u></p>
				    <p>സി).റേഷൻ കാർഡ് കളർ    :<u>'.$family_details->ration_card_color.'</u></p>
				    <?php }?>
				    <p>8.ഭൂമി</p>
				    <p>എ).സ്വന്തമായി ഭൂമി ഉണ്ടോ    ?  :<u>'.$family_details->land.'</u></p>
				    <p>ബി).ഉണ്ടെങ്കിൽ  എത്ര  സെന്റ്  ?  :<u>'.$family_details->land_cent.'</u></p>
				    <p>9.കുടുംബശ്രീ അയൽക്കൂട്ടത്തിൽ അംഗംമാനോ  ? <u>'.$ayal_mem.'</u></p>
				    <?php if($ayal_mem == "yes"){?>
				    <p>എ).അയൽക്കൂട്ടത്തിന്റെ  പേരു  ?  :<u>'.$family_details->ayalkootam_name.'</u></p>
				    <p>ബി).ഉൾപ്പെടുന്ന വാർഡ് നമ്പർ      ?  :<u>'.$family_details->ayalkootam_ward_no.'</u></p>
				    <?php }?>
				    <p>10.അഗതിമന്ദിരത്തിൽ താമസിക്കാൻ തയാറാണോ ?: <u>'.$old_mem.'</u></p>';
				    $pdf->WriteHTML($htmlcontent2, true, 0, true, 0);
				    $pdf->AddPage();
				    $htmlcontent3 ='';

					if(isset($member_array) && !empty($member_array))
						{				 
						$htmlcontent3    .= '
											<p style="color:#852771">Family Member Details</p>
											<table cellspacing="0" cellpadding="1" border="1">
									         <tr >
									            <th style="background-color: #DDD; ">Name</th>
									            <th style="background-color: #DDD;">Sex</th>
									            <th style="background-color: #DDD;">Age</th>
									            <th style="background-color: #DDD;">Relation</th>
									            <th style="background-color: #DDD;">Job</th>
									            <th style="background-color: #DDD;">Physical Condition</th>
									            <th style="background-color: #DDD;">Pension</th>
									            <th style="background-color: #DDD;">Monthly Income</th>
									            <th style="background-color: #DDD;">Aadhar No </th>
									            <th style="background-color: #DDD;">Remarks</th>
									         </tr>';
						foreach($member_array as $each_member)
						  {
						  	if($each_member['gender'] == 1){
						      $gender = 'M';
						    }
						    if($each_member['gender'] == 2){
						      $gender = 'F';
						    }
						    if($each_member['gender'] == 3){
						      $gender = 'O';
						    }
						    if($each_member['physical_condition'] == 1){
						      $phy_cond = 'Y';
						    }else{
						      $phy_cond = 'N';
						    }
						    if($each_member['pension'] == 1){
						      $pension = 'Y';
						    }else{
						      $pension = 'N';
						    }
						    if(!empty($each_member['monthly_income'])){
						      $income = $each_member['monthly_income'];
						    }else{
						      $income ='-';
						    }
				         $htmlcontent3    .= '<tr>
				            <td>'.$each_member['member_name'].'</td>
				            <td>'.$gender.'</td>
				            <td>'.$each_member['age'] . ' Yrs'.'</td>
				            <td>'.$each_member['relation'].'</td>
				            <td>'.$each_member['job_title'].'</td>
				            <td> '.$phy_cond.'</td>
				            <td>'.$pension.'</td>
				            <td>'.$income.'</td>
				            <td>'.$each_member['aadhar_no'].'</td>
				            <td>'.$each_member['remarks'].'</td>
					        </tr>';
						if(isset($each_member['diseases']) && !empty($each_member['diseases']))
							{
								$d=1;
								$htmlcontent3    .= '<p style="color:#852771">Diseases of '.$each_member['member_name'].'</p>';
								foreach ($each_member['diseases'] as $diseases) 
								{
									if($diseases['answer'] == 1){$ans='Y';}else{$ans='N';}
									$htmlcontent3    .= '<tr><td width="50%;">('.$d.') ' . $diseases['questions'].'</td><td>'.$ans.'</td></tr>';
									$d++;
								}
						    	 
						    }   				 
									
	    			}
	    		$htmlcontent3    .= '</table>';
	    		$pdf->WriteHTML($htmlcontent3, true, 0, true, 0);
	    	}
	    	
	    	$htmlcontent4 ='';
	    	if(isset($member_issues) && !empty($member_issues))
				{  
					$y = 'Yes';$n= 'No';
					$htmlcontent4 .='<p style="color:#852771">Family Issues</p>
								<table cellspacing="0" cellpadding="1" border="1">';
					foreach ($member_issues as $is) 
					{
						if($is['answers'] == 2 ) {$ans='Y';}else{$ans='N';}
					$htmlcontent4 .='<tr>
								 <td>'.$is['questions'].'</td>
								 <td>'.$ans.'</td>
								 </tr>';
					}			 
					$htmlcontent4 .='</table>';
					$pdf->WriteHTML($htmlcontent4, true, 0, true, 0);
				}	
				
			$htmlcontent5 ='';
	    	if(isset($services) && !empty($services))
				{  
					if($services->food == 0){$f = 'Y';}else{$f = 'N';}
					if($services->medical == 0){$m = 'Y';}else{$m = 'N';}
					if($services->dress == 0){$d = 'Y';}else{$d = 'N';}
					if($services->land == 0){$l = 'Y';}else{$l = 'N';}
					if($services->home == 0){$h = 'Y';}else{$h = 'N';}
					if($services->water == 0){$w = 'Y';}else{$w = 'N';}
					if($services->job == 0){$j = 'Y';}else{$j = 'N';}
					if($services->pension == 0){$p = 'Y';}else{$p = 'N';}
					if($services->education == 0){$e = 'Y';}else{$e = 'N';}
					if($services->service_needed == 0){$s = 'Y';}else{$s = 'N';}
					
					$htmlcontent5 .='<p style="color:#852771">Family services</p>
								<table cellspacing="0" cellpadding="1" border="1">';				
					$htmlcontent5 .='<tr ><td ><strong>Services Needed</strong></td><td><strong>Yes/No</strong></td><td><strong>Amount</strong></td></tr>';	
					$htmlcontent5 .='<tr><td>Food</td><td>'.$f.'</td><td>'.$services->food_amt.'</td></tr>';			
					$htmlcontent5 .='<tr><td>Medical</td><td>'.$m.'</td><td>'.$services->medical_amt.'</td></tr>';		
					$htmlcontent5 .='<tr><td>Dress</td><td>'.$d.'</td><td>'.$services->dress_amt.'</td></tr>';			
					$htmlcontent5 .='<tr><td>Land</td><td>'.$l.'</td><td>'.$services->land_amt.'</td></tr>';			
					$htmlcontent5 .='<tr><td>home</td><td>'.$h.'</td><td>'.$services->home_amt.'</td></tr>';			
					$htmlcontent5 .='<tr><td>water</td><td>'.$w.'</td><td>'.$services->water_amt.'</td></tr>';			
					$htmlcontent5 .='<tr><td>job</td><td>'.$j.'</td><td>'.$services->job_amt.'</td></tr>';				
					$htmlcontent5 .='<tr><td>pension</td><td>'.$p.'</td><td>'.$services->pension_amt.'</td></tr>';		
					$htmlcontent5 .='<tr><td>education</td><td>'.$e.'</td><td>'.$services->education_amt.'</td></tr>';	
					$htmlcontent5 .='<tr><td>service needed</td><td>'.$s.'</td><td>'.$services->service_amt.'</td></tr>';
					

					$htmlcontent5 .='</table>';
					$pdf->WriteHTML($htmlcontent5, true, 0, true, 0);
				}	
				$pdf->AddPage();
				
				$latitude = json_decode($family_details->latitude);
				$longitude= json_decode($family_details->longitude);

				$a=array();
				
				for ($i=0; $i <count($latitude) ; $i++) { 
					array_push($a,$latitude[$i],$longitude[$i]);
				}
				
				$googleMap = $pdf->Image(
    'http://maps.google.com/maps/api/staticmap?zoom=14&size=800x800&maptype=roadmap&markers=color:green|label:A|'.$latitude[0].','.$longitude[0].'&sensor=false', 
    20, 20, 90, 90, '', '', '', false, 600);


    			
    			$pdf->WriteHTML($googleMap, true, 0, true, 0);
				$pdf->Output($page.'.pdf', 'I'); 
			}
		else
			{
				redirect('survey_list');
			}

	}

	  
		
}